﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using FDK;

namespace StrokeStyleT
{
	class CStage結果 : CActivity
	{
		public CStage結果()
		{
			this.list子Activities.Add( this.Actホワイトイン = new CMActフェードイン・透明度( 1 ) );
			this.list子Activities.Add( this.Actブラックアウト = new CMActフェードアウト・透明度( 1 ) );
			this.list子Activities.Add( this.Act結果パラメータ文字列描画 = new CMAct文字列描画( @"0123456789(.)%*", 47, 30 ) );
		}

		enum EフェーズID { フェードイン, 通常, フェードアウト }
		EフェーズID eフェーズID;

		public override void On活性化()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してる )
				return;
			//-----------------
			#endregion

			this.eフェーズID = EフェーズID.フェードイン;

			base.On活性化();
		}
		public override void Onリソースの作成()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return;
			//-----------------
			#endregion

			this.ms背景動画 = new CMediaSession( Global.App.hWindow, Folder.stgテーマファイル( @"ScreenResult BGV.mp4" ), false, true );
			
			base.Onリソースの作成();
		}
		public override void Onリソースの作成( IntPtr hDevice )
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return;
			//-----------------
			#endregion

			this.txWhite = new CTexture( hDevice, Folder.stgテーマファイル( @"White 64x64.png" ) );
			this.txBlack = new CTexture( hDevice, Folder.stgテーマファイル( @"Black 64x64.png" ) );
			this.tx背景 = new CTexture( hDevice, Folder.stgテーマファイル( @"ScreenResult background.png" ) );
			this.tx結果表示パラメータパネル = new CTexture( hDevice, Folder.stgテーマファイル( @"ScreenResult parameter panel.png" ) );
			this.tx結果パラメータフォント = new CTexture( hDevice, Folder.stgテーマファイル( @"ScreenResult parameter font.png" ) );

			for( int i = 0; i < 15; i++ )
				this.tx結果パラメータフォント.list描画範囲.Add( new Rectangle( ( i % 5 ) * 30, ( i / 5 ) * 58, 30, 58 ) );

			base.Onリソースの作成( hDevice );
		}
		public override void Onリソースの解放()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return;
			//-----------------
			#endregion

			Global.tDisposeする( ref this.ms背景動画 );

			Global.tDisposeする( ref this.txWhite );
			Global.tDisposeする( ref this.txBlack );
			Global.tDisposeする( ref this.tx背景 );
			Global.tDisposeする( ref this.tx結果表示パラメータパネル );
			Global.tDisposeする( ref this.tx結果パラメータフォント );

			base.Onリソースの解放();
		}
		public override int On進行()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return (int) E進行結果.継続;
			//-----------------
			#endregion


			// 進行。

			#region [ 初めての進行処理。]
			//-----------------
			if( this.b初めての進行 )
			{
				if( this.ms背景動画 != null )
					this.ms背景動画.t再生する( 0 );

				this.Actホワイトイン.t開始();
				this.b初めての進行 = false;
			}
			//-----------------
			#endregion

			#region [ フェードイン → 完了したら通常フェーズへ ]
			//-----------------
			if( this.eフェーズID == EフェーズID.フェードイン )
			{
				if( this.Actホワイトイン.b完了 )
					this.eフェーズID = EフェーズID.通常;

				this.Actホワイトイン.On進行();	// 進行は完了チェックの後に！
			}
			//-----------------
			#endregion
			#region [ フェードアウト → 完了したらステージ終了 ]
			//-----------------
			if( this.eフェーズID == EフェーズID.フェードアウト )
			{
				if( this.Actブラックアウト.b完了 )
					return (int) E進行結果.完了;

				this.Actブラックアウト.On進行();	// 進行は完了チェックの後に！
			}
			//-----------------
			#endregion


			// 入力。

			#region [ ESC or シンバル類 → ブラックアウトフェーズへ ]
			//-----------------
			if( Global.Input.Input管理.Keyboard.bキーが押された( Key.Escape ) ||
				Global.Input.bシンバル類のいずれかが押された )
			{
				if( this.eフェーズID != EフェーズID.フェードアウト )
				{
					this.Actブラックアウト.t開始();
					this.eフェーズID = EフェーズID.フェードアウト;
				}
			}
			//-----------------
			#endregion

			return (int) E進行結果.継続;
		}
		public override void On描画( IntPtr hDevice )
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return;
			//-----------------
			#endregion

			#region [ 背景動画 ]
			//-----------------
			if( this.ms背景動画 != null )
				this.ms背景動画.t最新のサンプルを描画する();
			//-----------------
			#endregion
			#region [ 背景 ]
			//-----------------
			if( this.tx背景 != null )
				this.tx背景.t2D描画( hDevice, 0, 0 );
			//-----------------
			#endregion
			#region [ 結果パラメータパネル ]
			//-----------------
			if( this.tx結果表示パラメータパネル != null )
				this.tx結果表示パラメータパネル.t2D描画( hDevice, 40, 131 );
			//-----------------
			#endregion
			#region [ 結果パラメータ ]
			//-----------------
			var sb文字列 = new StringBuilder();

			int n総数 = 0;
			for( int i = 0; i <= 5; i++ )
				n総数 += Global.Stage.演奏.dicヒットした回数[ (E判定) i ];

			for( int i = 0; i <= 5; i++ )
				sb文字列.Append( this.t結果パラメータ文字列を作成する( Global.Stage.演奏.dicヒットした回数[ (E判定) i ], n総数 ) );

			this.Act結果パラメータ文字列描画.t表示( hDevice, this.tx結果パラメータフォント, 240, 155, sb文字列.ToString() );
			//-----------------
			#endregion

			#region [ フェードイン ]
			//-----------------
			if( this.eフェーズID == EフェーズID.フェードイン )
				this.Actホワイトイン.On描画( hDevice, this.txWhite, Global.App.Direct3D );
			//-----------------
			#endregion
			#region [ フェードアウト ]
			//-----------------
			if( this.eフェーズID == EフェーズID.フェードアウト )
				this.Actブラックアウト.On描画( hDevice, this.txBlack, Global.App.Direct3D );
			//-----------------
			#endregion
		}

		CMActフェードイン・透明度 Actホワイトイン;
		CMActフェードアウト・透明度 Actブラックアウト;
		CTexture txWhite;
		CTexture txBlack;

		CMAct文字列描画 Act結果パラメータ文字列描画 = null;
		CMediaSession ms背景動画 = null;
		CTexture tx背景 = null;
		CTexture tx結果表示パラメータパネル = null;
		CTexture tx結果パラメータフォント = null;

		string t結果パラメータ文字列を作成する( int n値, int n総数 )
		{
			var sb = new StringBuilder( 32 );

			sb.Append( n値.ToString( "00000" ) );
			for( int n桁 = 0; n桁 < 4; n桁++ )
			{
				if( sb[ n桁 ] == '0' )
					sb[ n桁 ] = '*';
				else
					break;
			}
			sb.Append( string.Format( "({0,5:F1}%)\n", ( (double) n値 * 100.0 / (double) n総数 ) ) );

			return sb.ToString();
		}
	}
}
